----------------------------------------------------------------------------------
-- Company: 
-- Engineer: Christoph Raab
-- 
-- Create Date:    20:45:14 09/25/2011 
-- Design Name: 
-- Module Name:    disk_modul - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--

-- This program is free software; you can redistribute it and/or modify it under the terms of the 
-- GNU General Public License as published by the Free Software Foundation; either version 3 of the 
-- License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
-- See the GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License along with this program; 
-- if not, see <http://www.gnu.org/licenses/>. 

-- Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der GNU General Public License, 
-- wie von der Free Software Foundation verffentlicht, weitergeben und/oder modifizieren, entweder gem 
-- Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
-- Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen von Nutzen sein wird, aber 
-- OHNE IRGENDEINE GARANTIE, sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR 
-- EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
-- Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem Programm erhalten haben. 
-- Falls nicht, siehe <http://www.gnu.org/licenses/>. 

----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

-- Nomenklatur der PINs
-- ohne _DISK: Verbindungen Richtung Amiga
-- mit _DISK: Verbindung Richtung Laufwerk
-- xxx_yyy_DISK: 
--		xxx Funktion im Amiga Modus
--		yyy Funktion im PC Modus

entity disk_modul is
    Port ( SEL0 : in  STD_LOGIC;
           SEL1 : in  STD_LOGIC;
           MTR : in  STD_LOGIC;
           IORST : in  STD_LOGIC;
           DIR : in  STD_LOGIC;
           STEP : in  STD_LOGIC;
           DKWD : in  STD_LOGIC;
           DKWE : in  STD_LOGIC;
           SIDE : in  STD_LOGIC;
           AMIGAPC : in  STD_LOGIC;
           HDFIX : in  STD_LOGIC;
			  READY : out  STD_LOGIC;
			  DISKCHANGE : out  STD_LOGIC;
			  READY_GEN_IN : in  STD_LOGIC;
			  SECOND_DRIVE_IN : in  STD_LOGIC;

			  DISKCHANGE_HD0_DISK : in  STD_LOGIC;
			  NC_HD1_DISK : in  STD_LOGIC;
           INUSE0_NC_DISK : out  STD_LOGIC;
			  NC_CLKIN0_DISK : in  STD_LOGIC;
			  NC_CLKIN1_DISK : in  STD_LOGIC;
           INUSE1_CLKOUT0_DISK : out  STD_LOGIC;
			  NC_CLKOUT1_DISK : out  STD_LOGIC;
			  SEL0_MTRI0_DISK : out  STD_LOGIC;
			  NC_MTRI1_DISK : out  STD_LOGIC;
			  SEL1_HDDISKIN_DISK : out  STD_LOGIC;
			  NC_SEL0_DISK : out  STD_LOGIC;
			  NC_SEL1_DISK : out  STD_LOGIC;
			  MTRI0_NC_DISK : out  STD_LOGIC;
           DIR_DISK : out  STD_LOGIC;
           STEP_DISK : out  STD_LOGIC;
           DKWD_DISK : out  STD_LOGIC;
           DKWE_DISK : out  STD_LOGIC;
           SIDE_DISK : out  STD_LOGIC;
			  READY_DISKCHANGE_DISK : in  STD_LOGIC
			);
end disk_modul;

architecture Behavioral of disk_modul is
shared variable MOTORON0_INT, MOTORON1_INT: STD_LOGIC;
begin
	process(DIR,STEP,DKWD,DKWE,SIDE)
	begin
		if DIR='0' then
			DIR_DISK <= '0';	--	DIR, STEP,DKWD, DKWE und SIDE werden unabhngig vom Modus 1:1 durchgereicht.
		else
			DIR_DISK <= 'Z';
		end if;
		if STEP='0' then
			STEP_DISK <= '0';
		else
			STEP_DISK <= 'Z';
		end if;
		if DKWD='0' then
			DKWD_DISK <= '0';
		else
			DKWD_DISK <= 'Z';
		end if;
		if DKWE='1' then
			DKWE_DISK <= '0';
		else
			DKWE_DISK <= 'Z';
		end if;
		if SIDE='0' then
			SIDE_DISK <= '0';
		else
			SIDE_DISK <= 'Z';
		end if;
	end process;

	process(AMIGAPC,SEL0,SEL1,MTR,IORST,READY_DISKCHANGE_DISK,DISKCHANGE_HD0_DISK,NC_CLKIN0_DISK,NC_CLKIN1_DISK,READY_GEN_IN,SECOND_DRIVE_IN,HDFIX,NC_HD1_DISK)
	variable READY_HD0, READY_HD1: STD_LOGIC;
	variable CLK0_INT,CLK1_INT : STD_LOGIC;
	begin
		if IORST='0' then  -- bei Reset werden alle Ausgnge hochohmig
			INUSE0_NC_DISK <='Z';
			INUSE1_CLKOUT0_DISK <='Z';
			NC_CLKOUT1_DISK <='Z';
			SEL0_MTRI0_DISK <='Z';
			NC_MTRI1_DISK <='Z';
			SEL1_HDDISKIN_DISK <='Z';
			NC_SEL0_DISK <='Z';
			NC_SEL1_DISK <='Z';
			MTRI0_NC_DISK <='Z';
			DISKCHANGE <= 'Z';
			READY <= 'Z';
      else
			-- Motorregister
			if falling_edge(SEL0) then		-- das Motorsignal wird bei fallender SEL0 Flanke ausgewertet
				if MTR='0' then
					MOTORON0_INT := '0';		-- Motor an !
				else 
					MOTORON0_INT := '1';		-- Motor aus !
				end if;
			end if;
			if falling_edge(SEL1) then		-- das Motorsignal wird bei fallender SEL0 Flanke ausgewertet
				if MTR='0' then
					MOTORON1_INT := '0';		-- Motor an !
				else 
					MOTORON1_INT := '1';		-- Motor aus !
				end if;
			end if;
			-- Ende Motorregister
			
			if AMIGAPC='1' then --wenn Amigalaufwerke
				
				-- Motorsignale
				INUSE0_NC_DISK <= MOTORON0_INT;		-- LED 0 geht an, wenn Laufwerk 0 drehen soll
				INUSE1_CLKOUT0_DISK <= MOTORON1_INT; 	-- LED 1 geht an, wenn Laufwerk 1 drehen soll
				if MOTORON0_INT='0' or MOTORON1_INT='0' then		-- wenn eins drehen soll werden
					MTRI0_NC_DISK <= '0';					-- die Motoren beider Laufwerke eingeschaltet
				else
					MTRI0_NC_DISK <= '1';
				end if;
				NC_MTRI1_DISK <= 'Z';						-- unbenutzter Ausgang
				
				-- Ready
				if (SEL1 = '0' and SECOND_DRIVE_IN = '0' and MOTORON1_INT = '1') then
					READY <= '0';									-- wenn DF1 ein 880k Laufwerk ist, muss READY anders behandelt werden
				else
					READY <= READY_DISKCHANGE_DISK;			-- Ready-Signal wird weitergereicht
				end if;
				
				-- Diskchange
				DISKCHANGE <= DISKCHANGE_HD0_DISK;		-- Diskchange-Signal wird weitergereicht
				
				-- Select
				SEL0_MTRI0_DISK <= SEL0;					-- Selekt-Signale werden weitergereicht
				SEL1_HDDISKIN_DISK <= SEL1;
				NC_SEL0_DISK <= 'Z';							-- unbenutzter Ausgang
				NC_SEL1_DISK <= 'Z';							-- unbenutzter Ausgang
				
				-- Clk fr HD-Laufwerke
				NC_CLKOUT1_DISK <= 'Z';						-- unbenutzter Ausgang
				
			else --wenn PC Laufwerke
				
				INUSE0_NC_DISK <= 'Z';						-- gemischten Ein/Ausgang hochohmig schalten, damit das Clockignal durch kommt
				
				--Motorsignale
				if MOTORON0_INT='0' then					-- wenn Motor 0 drehen soll, wird Motor 0 eingeschaltet
					SEL0_MTRI0_DISK <= '0';
				else
					SEL0_MTRI0_DISK <= '1';
				end if;
				if MOTORON1_INT='0' then					-- wenn Motor 1 drehen soll, wird Motor 1 eingeschaltet
					NC_MTRI1_DISK <= '0';
				else
					NC_MTRI1_DISK <= '1';
				end if;
				MTRI0_NC_DISK <= 'Z';						-- unbenutzter Ausgang
				
				-- Ready Erzeugung
				-- hier wird das Bitpattern zur Erkennung der HD-Laufwerke erzeugt
				if MOTORON0_INT='0' then
					READY_HD0 := '0';							-- luft der Motor, bleibt die Variable konstant
				else
					if DISKCHANGE_HD0_DISK='1' and HDFIX='0' then  -- ist der Motor aus, HD-Fix aktiv und eine HD-Disk eingelegt
						if rising_edge(SEL0) then
							READY_HD0 := not READY_HD0;		-- alterniert Ready bei jeder steigenden Flanke von SEL0
						end if;
					else
						READY_HD0 := '0';							-- sonst bleibt Ready 0
					end if;
				end if;
				if MOTORON1_INT='0' then						-- analog fr Laufwerk 1
					READY_HD1 := '0';
				else
					if NC_HD1_DISK='1' and HDFIX='0' then
						if rising_edge(SEL1) then
							READY_HD1 := not READY_HD1;
						end if;
					else
						READY_HD1 := '0';
					end if;
				end if;
				
				if (SEL0='0' and DISKCHANGE_HD0_DISK='1' and HDFIX='0') or (SEL1='0' and NC_HD1_DISK='1' and HDFIX='0') then
					SEL1_HDDISKIN_DISK <= '0';			-- ber diesen Ausgang wird dem C mitgeteilt, ob eine HD-Diskette eingelegt ist
				else
					SEL1_HDDISKIN_DISK <= 'Z';
				end if;
				
				-- luft der Motor des selektierten Laufwerks und das extern erzeugt READY_GEN Signal ist 0, wird Ready auf 0 gezogen
				if (SEL0='0' and MOTORON0_INT='0' and READY_GEN_IN='0') or (SEL1='0' and MOTORON1_INT='0' and READY_GEN_IN='0') then
					READY <= '0';
				else
					-- wird Laufwerk selektiert und der Motor ist aus, wird bei einer HD-Diskette das Bitpattern fr HD auf Ready ausgegeben
					if (SEL0='0' and MOTORON0_INT='1' and READY_HD0='0') or (SEL1='0' and MOTORON1_INT='1' and READY_HD1='0' and SECOND_DRIVE_IN='0') then
						READY <= '0';
					else
						READY <= 'Z';
					end if;
				end if;

				-- Diskchange
				DISKCHANGE <= READY_DISKCHANGE_DISK;
				
				-- Select
				NC_SEL0_DISK <= SEL0;
				NC_SEL1_DISK <= SEL1;
								
				-- Clk fr HD-Laufwerke
				if HDFIX='0' then
					if DISKCHANGE_HD0_DISK='1' then				-- wenn eine HD-Diskette eingelegt ist
						if rising_edge(NC_CLKIN0_DISK) then
							CLK0_INT := not CLK0_INT;				-- wird die Clock halbiert
						end if;
					else
						CLK0_INT := NC_CLKIN0_DISK;				-- ansosnten durch gereicht
					end if;
					INUSE1_CLKOUT0_DISK <= CLK0_INT;
					if NC_HD1_DISK='1' then
						if rising_edge(NC_CLKIN1_DISK) then
							CLK1_INT := not CLK1_INT;
						end if;
					else
						CLK1_INT := NC_CLKIN1_DISK;
					end if;
					NC_CLKOUT1_DISK <= CLK1_INT;
				else
					INUSE1_CLKOUT0_DISK <= 'Z';
					NC_CLKOUT1_DISK <= 'Z';
				end if;
			end if; 
		end if;
	end process;
	
end Behavioral;

